/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.connected;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_7775;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_787;
import net.minecraft.class_793;
import net.minecraft.class_806;
import slimeknights.mantle.block.IMultipartConnectedBlock;
import slimeknights.mantle.client.model.ModelProperty;
import slimeknights.mantle.client.model.connected.ConnectedModelRegistry;
import slimeknights.mantle.client.model.data.SinglePropertyData;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.ExtraTextureConfiguration;
import slimeknights.mantle.client.model.util.ModelTextureIteratable;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class ConnectedModel
implements IUnbakedGeometry<ConnectedModel> {
    private static final ModelProperty<Byte> CONNECTIONS = new ModelProperty();
    private final SimpleBlockModel model;
    private final Map<String, String[]> connectedTextures;
    private final BiPredicate<class_2680, class_2680> connectionPredicate;
    private final Set<class_2350> sides;

    public void resolveParents(Function<class_2960, class_1100> modelGetter, class_793 context) {
        this.model.resolveParents(modelGetter, context);
    }

    public class_1087 bake(class_793 owner, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 transform, class_806 overrides, class_2960 location, boolean isGui3d) {
        HashMap<CallSite, class_4730> extraTextures = new HashMap<CallSite, class_4730>();
        for (Map.Entry<String, String[]> entry : this.connectedTextures.entrySet()) {
            String[] suffixes;
            String name = entry.getKey();
            if (!owner.method_3432(name)) continue;
            class_4730 base = owner.method_24077(name);
            class_2960 atlas = base.method_24144();
            class_2960 texture = base.method_24147();
            String namespace = texture.method_12836();
            String path = texture.method_12832();
            for (String suffix : suffixes = entry.getValue()) {
                String suffixedName;
                if (suffix.isEmpty() || extraTextures.containsKey(suffixedName = name + "_" + suffix)) continue;
                class_4730 mat = owner.method_3432(suffixedName) ? owner.method_24077(suffixedName) : new class_4730(atlas, new class_2960(namespace, path + "/" + suffix));
                extraTextures.put((CallSite)((Object)suffixedName), mat);
            }
        }
        class_1087 baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, location);
        return new Baked(this, new ExtraTextureConfiguration(owner, (Map<String, class_4730>)ImmutableMap.copyOf(extraTextures)), transform, baked);
    }

    protected ConnectedModel(SimpleBlockModel model, Map<String, String[]> connectedTextures, BiPredicate<class_2680, class_2680> connectionPredicate, Set<class_2350> sides) {
        this.model = model;
        this.connectedTextures = connectedTextures;
        this.connectionPredicate = connectionPredicate;
        this.sides = sides;
    }

    protected static class Baked
    extends DynamicBakedWrapper<class_1087> {
        private final ConnectedModel parent;
        private final class_793 owner;
        private final class_3665 transforms;
        private final class_1087[] cache = new class_1087[64];
        private final Map<String, String> nameMappingCache = new ConcurrentHashMap<String, String>();
        private final ModelTextureIteratable modelTextures;

        public Baked(ConnectedModel parent, class_793 owner, class_3665 transforms, class_1087 baked) {
            super(baked);
            this.parent = parent;
            this.owner = owner;
            this.transforms = transforms;
            this.modelTextures = ModelTextureIteratable.of(owner, parent.model);
            this.cache[0] = baked;
        }

        private static class_2350 rotateDirection(class_2350 direction, class_2350 rotation) {
            if (rotation == class_2350.field_11036) {
                return direction;
            }
            if (rotation == class_2350.field_11033) {
                if (direction.method_10166() == class_2350.class_2351.field_11051) {
                    return direction.method_10153();
                }
                return direction;
            }
            switch (direction) {
                case field_11043: {
                    return class_2350.field_11036;
                }
                case field_11035: {
                    return class_2350.field_11033;
                }
                case field_11034: {
                    return rotation.method_10160();
                }
                case field_11039: {
                    return rotation.method_10170();
                }
            }
            throw new IllegalArgumentException("Direction must be horizontal axis");
        }

        private static Function<class_2350, class_2350> getTransform(class_2350 face, class_787 uv) {
            boolean flipV;
            Function<class_2350, class_2350> transform = d -> Baked.rotateDirection(d, face);
            boolean bl = flipV = uv.field_4235[1] > uv.field_4235[3];
            if (uv.field_4235[0] > uv.field_4235[2]) {
                transform = flipV ? transform.compose(class_2350::method_10153) : transform.compose(d -> {
                    if (d.method_10166() == class_2350.class_2351.field_11048) {
                        return d.method_10153();
                    }
                    return d;
                });
            } else if (flipV) {
                transform = transform.compose(d -> {
                    if (d.method_10166() == class_2350.class_2351.field_11051) {
                        return d.method_10153();
                    }
                    return d;
                });
            }
            return switch (uv.field_4234) {
                case 90 -> transform.compose(class_2350::method_10170);
                case 180 -> transform.compose(class_2350::method_10153);
                case 270 -> transform.compose(class_2350::method_10160);
                default -> transform;
            };
        }

        private String getConnectedNameUncached(String key) {
            String check = key;
            String found = "";
            for (Map textures : this.modelTextures) {
                Either either = (Either)textures.get(check);
                if (either == null) continue;
                Optional newName = either.right();
                if (newName.isEmpty()) break;
                check = (String)newName.get();
                if (!this.parent.connectedTextures.containsKey(check)) continue;
                found = check;
                break;
            }
            return found;
        }

        private String getConnectedName(String key) {
            if (key.charAt(0) == '#') {
                key = key.substring(1);
            }
            if (this.parent.connectedTextures.containsKey(key)) {
                return key;
            }
            return this.nameMappingCache.computeIfAbsent(key, this::getConnectedNameUncached);
        }

        private String getTextureSuffix(String texture, byte connections, Function<class_2350, class_2350> transform) {
            int key = 0;
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                int flag = 1 << transform.apply(dir).method_10146();
                if ((connections & flag) != flag) continue;
                key |= 1 << dir.method_10161();
            }
            String[] suffixes = this.parent.connectedTextures.get(texture);
            assert (suffixes != null);
            String suffix = suffixes[key];
            if (suffix.isEmpty()) {
                return suffix;
            }
            return "_" + suffix;
        }

        private class_1087 applyConnections(byte connections) {
            ArrayList elements = Lists.newArrayList();
            for (class_785 part : this.parent.model.getElements()) {
                EnumMap<class_2350, class_783> partFaces = new EnumMap<class_2350, class_783>(class_2350.class);
                for (Map.Entry entry : part.field_4230.entrySet()) {
                    String suffix;
                    class_783 original;
                    class_2350 dir = (class_2350)entry.getKey();
                    class_783 face = original = (class_783)entry.getValue();
                    String connectedTexture = this.getConnectedName(original.field_4224);
                    if (!connectedTexture.isEmpty() && !(suffix = this.getTextureSuffix(connectedTexture, connections, Baked.getTransform(dir, original.field_4227))).isEmpty()) {
                        String fullTexture = connectedTexture + suffix;
                        face = new class_783(original.field_4225, original.field_4226, "#" + fullTexture, original.field_4227);
                    }
                    partFaces.put(dir, face);
                }
                elements.add(new class_785(part.field_4228, part.field_4231, partFaces, part.field_4232, part.field_4229));
            }
            return SimpleBlockModel.bakeDynamic(this.owner, elements, this.transforms);
        }

        private static byte getConnections(Predicate<class_2350> predicate) {
            byte connections = 0;
            for (class_2350 dir : class_2350.values()) {
                if (!predicate.test(dir)) continue;
                connections = (byte)(connections | 1 << dir.method_10146());
            }
            return connections;
        }

        @Nonnull
        public SinglePropertyData<Byte> getModelData(class_1920 world, class_2338 pos, class_2680 state, SinglePropertyData<Byte> tileData) {
            if (tileData.getData(CONNECTIONS) != null) {
                return tileData;
            }
            SinglePropertyData<Byte> data = tileData;
            if (!data.hasProperty(CONNECTIONS)) {
                data = new SinglePropertyData<Byte>(CONNECTIONS);
            }
            class_4590 rotation = this.transforms.method_3509();
            data.setData(CONNECTIONS, Baked.getConnections(dir -> this.parent.sides.contains(dir) && this.parent.connectionPredicate.test(state, world.method_8320(pos.method_10093(rotation.rotateTransform(dir))))));
            return data;
        }

        protected synchronized void getCachedQuads(byte connections, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
            if (this.cache[connections] == null) {
                this.cache[connections] = this.applyConnections(connections);
            }
            this.cache[connections].emitBlockQuads(blockView, state, pos, randomSupplier, context);
        }

        public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
            SinglePropertyData<Byte> data = this.getModelData(blockView, pos, state, new SinglePropertyData<Byte>(CONNECTIONS));
            Byte connections = data.getData(CONNECTIONS);
            if (connections == null) {
                class_4590 rotation = this.transforms.method_3509();
                connections = Baked.getConnections(dir -> {
                    if (!this.parent.sides.contains(dir)) {
                        return false;
                    }
                    class_2746 prop = IMultipartConnectedBlock.CONNECTED_DIRECTIONS.get(rotation.rotateTransform(dir));
                    return state.method_28498((class_2769)prop) && (Boolean)state.method_11654((class_2769)prop) != false;
                });
            }
            this.getCachedQuads(connections, blockView, state, pos, randomSupplier, context);
        }
    }

    public static class Loader
    implements IGeometryLoader<ConnectedModel> {
        public static final Loader INSTANCE = new Loader();

        public ConnectedModel read(JsonObject json, JsonDeserializationContext context) {
            EnumSet<class_2350> sides;
            SimpleBlockModel model = SimpleBlockModel.deserialize(context, json);
            JsonObject data = class_3518.method_15296((JsonObject)json, (String)"connection");
            JsonObject connected = class_3518.method_15296((JsonObject)data, (String)"textures");
            if (connected.size() == 0) {
                throw new JsonSyntaxException("Must have at least one texture in connected");
            }
            ImmutableMap.Builder connectedTextures = new ImmutableMap.Builder();
            for (Map.Entry entry : connected.entrySet()) {
                String name = (String)entry.getKey();
                connectedTextures.put((Object)name, (Object)ConnectedModelRegistry.deserializeType((JsonElement)entry.getValue(), "textures[" + name + "]"));
            }
            if (data.has("sides")) {
                JsonArray array = class_3518.method_15261((JsonObject)data, (String)"sides");
                sides = EnumSet.noneOf(class_2350.class);
                for (int i = 0; i < array.size(); ++i) {
                    String side = class_3518.method_15287((JsonElement)array.get(i), (String)("sides[" + i + "]"));
                    class_2350 dir = class_2350.method_10168((String)side);
                    if (dir == null) {
                        throw new JsonParseException("Invalid side " + side);
                    }
                    sides.add(dir);
                }
            } else {
                sides = EnumSet.allOf(class_2350.class);
            }
            BiPredicate<class_2680, class_2680> predicate = ConnectedModelRegistry.deserializePredicate(data, "predicate");
            return new ConnectedModel(model, (Map<String, String[]>)connectedTextures.build(), predicate, sides);
        }
    }
}

